#### **Zetvl System Overview**

**Background & Positioning:**  
The Zetvl system is an extensive code modification project for the strategy game **Age of History II** (Official Developer: **Łukasz Jakowski**). Developed by independent creator **Fanillanus**, the system derives its name from the **Project-Zetvl** mod created concurrently by the same developer.

**Project-Zetvl Mod Specifications:**

* **Author:** Fanillanus  
* **Content:** Includes a map adapted from *Hearts of Iron IV*, leader adjustments, and a limited number of new civilizations.  
* **Status:** Development began June 2024 (led by Fanillanus) and remains incomplete.  
* **Technical Dependencies (Historical):** PC version utilized the BE system; Android version used the Uwut system.

**Origin and Naming of Zetvl System:**

* **Initial Development:** Code modification project initiated in 2024 by **Fanillanus** under the name "AoC2Plus+".  
* **Milestone: Android Port & Renaming (2025.02.24):**  
  * On February 24, 2025, **Fanillanus** successfully ported the Zetvl system core code to Android.  
  * The **code modification project** was formally renamed the **Zetvl System**, inheriting the version numbering scheme from the related **Project-Zetvl** mod.  
  * Starting from version 1.0.5.0, **Fanillanus'** Zetvl System entered an independent development phase.

**Project-Zetvl Mod History (Developed by Fanillanus):**

* **Development Start:** June 2024  
* **Android Release:** July 12, 2024 (Version 1.0 released by Fanillanus)  
* **Subsequent Updates:** 1.0.1, 1.0.2, 1.0.3, 1.0.4 (all updated by Fanillanus)  
* **Development Hiatus:** Mod version remained at 1.0.4.1 after August 2024.  
* **System Port Testing:** Mod version 1.0.4.2 (released February 24, 2025 by **Fanillanus**) specifically for testing the **Zetvl System** Android port.

* * *

#### **Zetvl System Historical Updates (Prior to 2025.06.09, Corresponding to Version 1.0.6.3 U1)**

> **Note:** Early update logs are incomplete. The following is reconstructed from memory and may contain omissions.

###### **September ~ December 2024**

* Numeric Type Optimization: Civilization population, economic output, etc., upgraded to `long integer` type.
* Large Number Display: Treasury, economy, population totals now use abbreviated notation (e.g., 18K, 36K).
* Engine Update: LibGDX library upgraded to version 1.13.
* Map Zoom Enhancement: Civilization names fade smoothly when map scale >1.
* Number Formatting: Digit separators changed from spaces to commas (e.g., 118,365,247).
* Combat System Integration: BE system combat logic integrated (with minor adjustments).
* Tech Impact Boost: Temporary strategy - Increased technological advantage effect in wars ("Tech Suppression").
* Date Format Localization: Adopted Chinese date format (e.g., January 16, 2025).
* Font Configuration: Added `fontSpec` option for custom title font rendering.
* Surrender System Integration: BE system surrender mechanics implemented.
* War Interface Enhancement: "Surrender Progress" displayed in war panel.
* UI Animation Upgrade: Non-linear easing animations applied to some menus.
* Tech Point Allocation Fix: Resolved issue where 5 tech points remained unused upon reaching Tech Level 2.0.
* Scenario Settings Adjustment: Increased max slider values for population, economy, military, treasury.
* War UI Visual Cue: Civilization indicators turn red if surrender progress >=100 or province count = 0.
* Pause Menu Expansion: Added "Change Game Settings" option.
* Custom Border Rendering: Place a PNG-encoded file named `pix2` (no extension) in `UI` folder to enable custom civilization borders.
* Scenario Editor Fix: Tech editor slider max value corrected (1.0 -> 2.0).
* Tech Research Algorithm: Improved civilization tech progress calculation.
* Battle Report Feature: Integrated BE2 system's "Show Battle Report" function.
* War Data Correction: Civilian casualties in war panel no longer counted as military losses.

###### **January 2025**

* Automated Map Connections: Implemented early province auto-connection algorithm (file comparison in `update` folder, more efficient than manual).

##### **Turning Point: Successful Android Port (2025.02.24)**

* Android Release: Zetvl System entered new development phase (version 1.0.5.0) following the Android port.

###### **March 2025**

* UI Visual Upgrade: Added animated backgrounds to loading and main menus.
* War Detail Enhancement: Source of military casualties (by civilization) visible in war panel.
* National Focus Prototype: External implementation of National Focus system (later ported internally).
* Delayed Recruitment: Added recruitment time mechanic (takes several to dozens of turns). Sandbox mode exempt. In-progress recruitment affects Movement Point (MP) gain per turn.
* AI Recruitment Logic: AI now only recruits if current MP > 3x recruitment cost.
* Automation Feature: Added "Auto Programs" option to player panel for functions like auto-attack/assimilation.
* Legacy Bug Fixes: Resolved lingering 2024 issues (console errors, war UI glitches).
* Config Folder: Created `ZetvlUniverse` for system config files (initial storage for National Focus files).
* Surrender Algorithm: Adjusted to `(Proportion of lost Victory Points) x (Additional Factors)`.
* Custom Menu Background: Place `bg_game.png` in `UI` folder to set main menu background.

###### **April 2025**

* National Focus Internalization: Migrated external National Focus system into core game (early dev version, view-only).
* Map Zoom Animation: Upgraded to non-linear easing animation.
* Startup UI Tweak: Optimized game launch screen layout.
* Province Data Packing: Enabled packing `map/MapName/data/provinces` files into single archive for portability and load speed.
* New Console Command: `seesea` activates observer mode.
* Combat Breakthrough Adjustment: BE system unit breakthrough rate now scales proportionally with game speed setting.
* Music Player Upgrade: Added playlist support.
* Standardized Settings: Game settings (`setting`) saved in JSON format at root directory for external editing.
* Nuclear System Foundation: Integrated partial functionality from "Nuclear Age" mod.
* National Focus Rewrite: Core system rebuilt with basic functionality late-April.
* Textbox Enhancement: Added auto-wrapping text support.
* War State Restriction: Capitulated civilizations cannot launch attacks from their territory.
* Leader Render Toggle: Modified `ORIGINAL_LEADER_RENDER` in Zetvl config to switch leader display modes.
* Border Algorithm: Optimized civilization border rendering using trigonometric calculations.
* Engine Downgrade: LibGDX reverted to version 1.9.14.

###### **May 2025**

* New UI Style: Added TNO-inspired Super Event UI.
* Event Tooltip Enhancement: Event decision hover text supports custom content and colored text.
* Scenario Load Optimization: Improved scenario loading speed.
* DEBUG Mode Upgrade: Added in-game log panel for real-time output.
* Vassal Color Sync: Vassal colors now match their overlord.
* Vassal War Restriction: Vassals cannot declare war (no independent diplomacy).
* National Focus Update: Focuses can be started; completion triggers effects (currently events only). Active focuses shown in right-side panel.
* Expanded UI Animation: More UI elements (e.g., civilization messages) use non-linear animations.
* Map Data Tool: Added AoH3 -> AoH2 province migration function (still imperfect).
* Connection UI Option: Added "Remove All Connections" to province link interface (originally for auto-connection testing).
* Memory Leak Fixes: Resolved critical memory leaks.
* Graphics Folder: Created `gfx` folder for National Focus images and new UI assets.
* Sandbox Enhancement: Grants 10,000 MP, 10,000 Diplo Points, 32,768 nukes, and 1 billion gold. Inflation disabled.
* Font Rendering Fix: Optimized font generation and fixed rendering issues.
* Province Scale Packing: Enabled packing `map/MapName/data/scales/provinces/[scale]` files. 
* Android Crash Handling: Android version now displays crash window instead of immediate exit.
* New Console Command: `throw` triggers a crash (testing).
* UTF-8 Standardization: All file I/O uses UTF-8 encoding (supports non-ASCII chars e.g., Chinese).
* Global Events: Events targeting "Neutral" are broadcast to all civilizations.
* Terrain Data Format: Upgraded terrain files to JSON format for external editing.
* New Console Command: `nuke` adds 1 nuke; `nuke 100` adds 100 nukes.
* Logging Enhancement: Enable `LOGS` in config for extended exception logging in console.
* Large Number Display: Re-added 10K/100M notation (e.g., 1W, 3E) via config option.
* Large Background Optimization: For Android, create `map/MapName/backgrounds/MapBG.txt` (format: `rows;columns;` e.g., `4;8;`) and place tiled images (e.g., `0_0.png`) for segmented loading.

###### **June 2025 (Through 06.09)**

* National Focus Polish: Added completion popup; implemented dedicated focus translation files.
* Message Display Fix: Resolved issue where some civilization messages failed to appear.
* Startup Animation: Enhanced game launch animation.
* Code Refactoring: Internal code structure and file naming conventions revised.
* Music Player UI: Updated music player panel interface.
* National Focus UI Tuning: Improved icon scaling, layout, and progress indicators in focus details panel.
* Province Pack Optimization: Improved province data packing to reduce file size.
* Load Progress Adjustment: Optimized progress display during map loading and province initialization.
